package loquebot.body;

import java.util.logging.Logger;

import cz.cuni.pogamut.Client.AgentBody;

import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;

import cz.cuni.pogamut.MessageObjects.BotDamaged;
import cz.cuni.pogamut.MessageObjects.BotKilled;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.PlayerKilled;

import loquebot.Main;
import loquebot.util.LoqueListener;
import loquebot.util.LoqueWeaponInfo;
import loquebot.memory.LoqueMemory;

/**
 * Responsible for speech.
 *
 * @author Juraj Simlovic [jsimlo@matfyz.cz]
 * @version Tested on Pogamut 2 platform version 1.0.5.
 */
public class LoqueSpeech
{
    /**
     * Says something when the bot get's powered up.
     */
    public void speechPoweredUp ()
    {
        String[] msgs = new String[] {
            "Show yourselves and fight!",
            "Here comes your death!",
            "Search and destroy!",
            "Get ready suckers!",
            "I feel lucky now!",
        };

        speech (msgs, .6);
    }

    /*========================================================================*/

    /**
     * Says something when the bot scores a frag.
     * @param name Name of the fragged player.
     */
    private void speechScored (String name)
    {
        String weapon = LoqueWeaponInfo.getInfo(memory.inventory.getCurrentWeapon ()).title;

        // some messages are repeated to give them more priority
        String[] msgs = new String[] {
            "Die, Bitch!", "Die, Bitch!",
            "Get a bigger gun!",
            "Die, die, die my darling!",
            "Did I blew your head apart?",
            "Try the respawn button, sucker..",
            "You play like a girl!", "You play like a girl!",
            "You play like a girl!", "You play like a girl!",
            "That was too easy",
            "And stay down!",
            "Anyone else want some?", "Anyone else want some?",
            "Burrrrn baby!", "Burrrrn baby!", "Burrrrn baby!",
            "Is that your best?",
            "Woooooohaaaaaaa!!", "Woooooohaaaaaaa!!",
            "Who's got it?! Who's got it?!",
            "Kiss my shiny metal ass!", "Kiss my shiny metal ass!",
            "Looooser..",
            "Seeya!", "Seeya!", "Seeya!",
            "That gotta hurt!", "That gotta hurt!",
            "You die too easily..",
            "Your programming is inferior.",
            "Haha! With a " + weapon + "!", "Haha! With a " + weapon + "!",
            "That was a " + weapon + " honey.. A " + weapon,
            "That was a " + weapon + " honey.. Just a " + weapon,
            "That was a " + weapon + " honey.. You know what's " + weapon + "?",
            "Gotcha, " + name + "!", "Gotcha, " + name + "!",
            "There ain't no space for both of us, " + name,
            "What a lovely day today, " + name + ", isn't it?",
            "Just kidding, " + name + ", just kidding",
            "Are we there yet? Yes. Really? No.",
        };

        speech (msgs, .8);
    }

    /*========================================================================*/

    /**
     * Says something when the bot get's killed.
     * @param name Name of the killer.
     */
    private void speechKilled (String name)
    {
        String weapon = LoqueWeaponInfo.getInfo(memory.inventory.getCurrentWeapon ()).title;

        // some messages are repeated to give them more priority
        String[] msgs = new String[] {
            "With that? Are you kidding me?!",
            "Shit. Shit. Shit.",
            "That was close", "That was close", "That was close",
            "Nice one, " + name, "Nice one, " + name, "Nice one, " + name,
            "Critical failure! My system is going down.",
            "General protection fault! Respawning..",
            "Stop the game! I am too young to die!",
            "How the hell did you, " + name + ", got so many frags already?",
        };

        speech (msgs, .8);
    }

    /*========================================================================*/

    /**
     * Says something when the bot get's killed.
     */
    private void speechSuicided ()
    {
        String weapon = LoqueWeaponInfo.getInfo(memory.inventory.getCurrentWeapon ()).title;

        // some messages are repeated to give them more priority
        String[] msgs = new String[] {
            "Mon Dieu!",
            "I ain't ready for this shit..",
            "What was that?!", "What was that?!", "What was that?!",
            "That was unpleasant..", "That was unpleasant..",
            "That was unpleasant..", "That was unpleasant..",
            "Everything comes to an end..",
            "Holy Shit!", "Holy Shit!", "Holy Shit!",
            "Bring a sexton!", "Bring a sexton!",
            "Fatal error! Respawning..",
            "RuntimeException! Respawning..",
            "Segmentation fault. Terminating.",
            "SIGKILL", "SIGKILL", "SIGSEGV", "SIGSEGV",
        };

        speech (msgs, 1);
    }

    /*========================================================================*/

    /**
     * The last time the agent said hello..
     */
    private long speechSeeEnemyNext = 0;

    /**
     * Sends greetings when the bot spots an enemy after a long-time-no-see.
     * @param name Name of the enemy..
     */
    private void speechSeeEnemy (String name)
    {
        // prevent greetings of everyone
        if (speechSeeEnemyNext > System.currentTimeMillis ())
        {
            // what's going to be the next time we shall greet someone?
            speechSeeEnemyNext = System.currentTimeMillis () + 20000;
            // but not this time..
            return;
        }

        // what's going to be the next time we shall greet someone?
        // note: this time is "prolonged" by the chance of speech
        speechSeeEnemyNext = System.currentTimeMillis () + 60000;

        // some messages are repeated to give them more priority
        String[] msgs = new String[] {
            "Hi there, " + name + "",
            "Greetings, " + name + "",
            "Ahh, " + name + ", say hi to my gun!",
            "You're going down, " + name + "!",
            "Stop smiling, " + name + "!",
            "Time's up, " + name + "!",
            "Run, " + name + ", 'till you can!",
        };

        speech (msgs, .3);
    }

    /*========================================================================*/

    /**
     * Says something when the bot get's damaged.
     * @param name Name of the instigator. May be null.
     */
    private void speechDamaged (String name)
    {
        // some messages are repeated to give them more priority
        String[] msgs = new String[] {
            "What the f...!?",
            "That hurts!", "That hurts!",
            "Hey!", "Hey!", "Hey!",
            "Ouch!", "Ouch!", "Ouch!",
            "Medic!", "Medic!", "Medic!",
            "Hey! Stop nudging me!",
            "Ouch! You're gonna pay for this!",
        };

        speech (msgs, .05);
    }

    /*========================================================================*/

    /**
     * Makes a given chance of sending one of the given messages.
     * @param msgs Messages from which to choose.
     * @param chance Chance of sending the chosen message.
     */
    private void speech (String[] msgs, double chance)
    {
        // do we reach to the chance of sending a message
        if (Math.random () < (chance * main.optionSpeech))
        {
            // pick one message and send it
            body.sendGlobalMessage(
                msgs[(int) (Math.random () * msgs.length)]
            );
        }
    }

    /*========================================================================*/

    /**
     * Listening class for messages from engine.
     */
    private class Listener extends LoqueListener
    {
        /**
         * Someone fragged somebody.
         * @param msg Message to handle.
         */
        private void msgPlayerKilled (PlayerKilled msg)
        {
            // did this agent fragged?
            if (memory.self.hasID (msg.killerID))
            {
                // get kill info
                Player info = memory.players.getPlayer (msg.playerID);
                String name = (info == null) ? "null" : info.name;
                // speech
                speechScored (name);
            }
        }

        /**
         * Agent has died. Somehow.
         * @param msg Message to handle.
         */
        private void msgBotKilled (BotKilled msg)
        {
            // did the agent suicided?
            if (memory.self.hasID (msg.killerID))
            {
                // get kill info
                Player info = memory.players.getPlayer (msg.killerID);
                String name = (info == null) ? "null" : info.name;
                // speech
                speechSuicided ();
            }
            // no the agent got fragged
            else
            {
                // get kill info
                Player info = memory.players.getPlayer (msg.killerID);
                String name = (info == null) ? "null" : info.name;
                // speech
                speechKilled (name);
            }
        }

        /**
         * Agent spots another player.
         * @param msg Message to handle.
         */
        private void msgPlayer (Player msg)
        {
            // is it an enemy?
            if (memory.isEnemy (msg))
            {
                // speech
                speechSeeEnemy (msg.name);
            }
        }

        /**
         * Agent gets damaged.
         * @param msg Message to handle.
         */
        private void msgBotDamaged (BotDamaged msg)
        {
            // get damage info
            Player info = memory.players.getPlayer (msg.idInstigator);
            String name = (info == null) ? null : info.name;
            // speech
            speechDamaged (name);
        }

        /**
         * Message switch.
         * @param msg Message to handle.
         */
        protected void processMessage (MessageObject msg)
        {
            switch (msg.type)
            {
                case PLAYER_KILLED:
                    msgPlayerKilled ((PlayerKilled) msg);
                    return;
                case BOT_KILLED:
                    msgBotKilled ((BotKilled) msg);
                    return;
                case PLAYER:
                    msgPlayer ((Player) msg);
                    return;
                case BOT_DAMAGED:
                    msgBotDamaged ((BotDamaged) msg);
                    return;
            }
        }

        /**
         * Constructor: Signs up for listening.
         */
        private Listener ()
        {
            body.addTypedRcvMsgListener(this, MessageType.PLAYER_KILLED);
            body.addTypedRcvMsgListener(this, MessageType.BOT_KILLED);
            body.addTypedRcvMsgListener(this, MessageType.PLAYER);
            body.addTypedRcvMsgListener(this, MessageType.BOT_DAMAGED);
        }
    }

    /** Listener. */
    private LoqueListener listener;

    /*========================================================================*/

    /** Agent's main. */
    protected Main main;
    /** Loque memory. */
    protected LoqueMemory memory;
    /** Agent's body. */
    protected AgentBody body;
    /** Agent's log. */
    protected Logger log;

    /*========================================================================*/

    /**
     * Constructor.
     * @param main Agent's main.
     * @param memory Loque memory.
     */
    public LoqueSpeech (Main main, LoqueMemory memory)
    {
        // setup reference to agent
        this.main = main;
        this.memory = memory;
        this.body = main.getBody ();
        this.log = main.getLogger ();

        // create listener
        this.listener = new Listener ();
    }
}